"use strict";

window.onload = function() {
    let dateInput = document.getElementById("date");

    if (dateInput) {
        dateInput.addEventListener("change", dateChanged);
    }
};

function dateChanged() {
    let dateInput = document.getElementById("date");
    let output =  document.getElementById("output");

    let dateChosen = dateInput.valueAsDate;
    if (!dateChosen) return;

    const days = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];
    const months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

    let dayName = days[dateChosen.getUTCDay()];
    let monthName = months[dateChosen.getUTCMonth()];
    let year = dateChosen.getUTCFullYear();
    let dayNum = dateChosen.getUTCDate();

    let display = `Selected: ${dayName}, ${monthName} ${dayNum}, ${year}<br>`;

    const ms = 1000 * 60 * 60 * 24

function getDaysUntil(holidayMonth, holidayDay) {
    let holidayDate = new Date(Date.UTC(year, holidayMonth, holidayDay));

    if (dateChosen > holidayDate) {
        holidayDate.setUTCFullYear(year + 1);
    }
    let diff =holidayDate - dateChosen;
    return Math.ceil(diff / ms);
}

    let daysToHalloween = getDaysUntil(9, 31);
    let daysToChristmas = getDaysUntil(11, 25);
    let daysToValentines = getDaysUntil(1, 14);

    output.innerHTML = display +
    `Days until Halloween: ${daysToHalloween}<br>` +
    `Days until Christmas: ${daysToChristmas}<br>` +
    `Days until Valentines: ${daysToValentines}<br>`;
}